/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.biome;

import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_6539;
import xaero.map.MapProcessor;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.BiomeKeyManager;
import xaero.map.region.MapTile;

public class BiomeColorCalculator {
    public final BiomeKey UNREACHABLE_BIOME;
    public final BiomeKey RIVER_BIOME;
    private BiomeKeyManager biomeKeyManager;

    public BiomeColorCalculator(BiomeKeyManager biomeKeyManager) {
        this.UNREACHABLE_BIOME = biomeKeyManager.get("xaeroworldmap:unreachable_biome");
        this.RIVER_BIOME = biomeKeyManager.get(class_1972.field_9438.method_29177().toString());
        this.biomeKeyManager = biomeKeyManager;
    }

    public int getBiomeColor(class_6539 stateColorResolver, boolean overlay, class_2338.class_2339 pos, MapTile tile, class_2378<class_1959> biomeRegistry, MapProcessor mapProcessor) {
        if (stateColorResolver == null) {
            return -1;
        }
        int i = 0;
        int j = 0;
        int k = 0;
        int total = 0;
        int initX = pos.method_10263();
        int initZ = pos.method_10260();
        for (int o = -1; o < 2; ++o) {
            for (int p = -1; p < 2; ++p) {
                if (o != 0 && p != 0) continue;
                pos.method_10103(initX + o, pos.method_10264(), initZ + p);
                BiomeKey b = this.getBiomeAtPos((class_2338)pos, tile, mapProcessor);
                if (b == this.UNREACHABLE_BIOME) continue;
                if (b == null && overlay) {
                    b = this.RIVER_BIOME;
                }
                if (b == null) continue;
                int l = 0;
                class_1959 gen = this.biomeKeyManager.getBiome(b, biomeRegistry);
                if (gen == null) continue;
                l = stateColorResolver.getColor(gen, (double)pos.method_10263(), (double)pos.method_10260());
                i += l & 0xFF0000;
                j += l & 0xFF00;
                k += l & 0xFF;
                ++total;
            }
        }
        pos.method_10103(initX, pos.method_10264(), initZ);
        if (total == 0) {
            class_1959 defaultBiome = (class_1959)biomeRegistry.method_29107(class_1972.field_9438);
            if (defaultBiome == null) {
                return -1;
            }
            return stateColorResolver.getColor(defaultBiome, (double)pos.method_10263(), (double)pos.method_10260());
        }
        return i / total & 0xFF0000 | j / total & 0xFF00 | k / total;
    }

    public BiomeKey getBiomeAtPos(class_2338 pos, MapTile centerTile, MapProcessor mapProcessor) {
        MapTile tile;
        int tileX = pos.method_10263() >> 4;
        int tileZ = pos.method_10260() >> 4;
        MapTile mapTile = tile = tileX == centerTile.getChunkX() && tileZ == centerTile.getChunkZ() ? centerTile : mapProcessor.getMapTile(tileX, tileZ);
        if (tile != null && tile.isLoaded()) {
            return tile.getBlock(pos.method_10263() & 0xF, pos.method_10260() & 0xF).getBiome();
        }
        return this.UNREACHABLE_BIOME;
    }
}

