/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.omegamute.util;

import com.natamus.omegamute.events.MuteEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;

public class Util {
    private static String dirpath = System.getProperty("user.dir") + File.separator + "config" + File.separator + "omegamute";
    private static File dir = new File(dirpath);
    private static File file = new File(dirpath + File.separator + "soundmap.txt");

    public static boolean loadSoundFile() throws IOException, FileNotFoundException, UnsupportedEncodingException {
        MuteEvent.ismutedsoundmap = new HashMap();
        if (!dir.isDirectory() || !file.isFile()) {
            Util.generateSoundFile();
            return false;
        }
        String sounds = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "soundmap.txt", new String[0])));
        for (String sound : sounds.split("\n")) {
            if (sound.length() < 4) continue;
            String soundname = sound.replace(",", "");
            int mutedvalue = -1;
            if (soundname.startsWith("!")) {
                mutedvalue = 0;
                soundname = soundname.substring(1);
            } else if (soundname.contains("-")) {
                try {
                    String[] soundsplit = soundname.split("-");
                    if (soundsplit.length == 2) {
                        mutedvalue = Integer.parseInt(soundsplit[0]);
                        soundname = soundsplit[1];
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            MuteEvent.ismutedsoundmap.put(soundname.trim(), mutedvalue);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static void updateSoundFile() {
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(dirpath + File.separator + "soundmap.txt"), true);
            ArrayList<String> keyset = new ArrayList<String>(MuteEvent.ismutedsoundmap.keySet());
            Collections.sort(keyset);
            for (String string : keyset) {
                void var3_4;
                int mutedvalue = MuteEvent.ismutedsoundmap.get(string);
                if (mutedvalue >= 0) {
                    if (mutedvalue == 0) {
                        String string2 = "!" + string;
                    } else {
                        String string3 = mutedvalue + "-" + string;
                    }
                }
                writer.println((String)var3_4 + ",");
            }
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void generateSoundFile() throws FileNotFoundException, UnsupportedEncodingException {
        ArrayList<String> soundnames = new ArrayList<String>();
        Set soundlocations = class_2378.field_11156.method_10235();
        for (class_2960 soundlocation : soundlocations) {
            class_3414 sound = (class_3414)class_2378.field_11156.method_10223(soundlocation);
            soundnames.add(sound.method_14833().toString().replace("minecraft:", ""));
        }
        Collections.sort(soundnames);
        dir.mkdirs();
        PrintWriter writer = new PrintWriter(dirpath + File.separator + "soundmap.txt", "UTF-8");
        for (String soundname : soundnames) {
            MuteEvent.ismutedsoundmap.put(soundname, -1);
            writer.println(soundname + ",");
        }
        writer.close();
    }

    public static HashMap<String, Integer> getMutedSounds() {
        HashMap<String, Integer> mutedsounds = new HashMap<String, Integer>();
        ArrayList<String> keyset = new ArrayList<String>(MuteEvent.ismutedsoundmap.keySet());
        Collections.sort(keyset);
        for (String soundname : keyset) {
            int mutedvalue = MuteEvent.ismutedsoundmap.get(soundname);
            if (mutedvalue < 0) continue;
            mutedsounds.put(soundname, mutedvalue);
        }
        return mutedsounds;
    }

    public static List<String> muteWildcard(String wildcard, int culltime) {
        if (!dir.isDirectory() || !file.isFile()) {
            try {
                Util.generateSoundFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<String> mutedsounds = new ArrayList<String>();
        try {
            String sounds = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "soundmap.txt", new String[0])));
            for (String sound : sounds.split("\n")) {
                if (sound.length() < 4) continue;
                String soundname = sound.replace(",", "");
                int mutedvalue = -1;
                if (soundname.startsWith("!")) {
                    mutedvalue = 0;
                    soundname = soundname.substring(1);
                } else if (soundname.contains("-")) {
                    try {
                        String[] soundsplit = soundname.split("-");
                        if (soundsplit.length == 2) {
                            mutedvalue = Integer.parseInt(soundsplit[0]);
                            soundname = soundsplit[1];
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (soundname.toLowerCase().contains(wildcard.toLowerCase())) {
                    mutedvalue = culltime;
                    mutedsounds.add(soundname.trim());
                }
                MuteEvent.ismutedsoundmap.put(soundname.trim(), mutedvalue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mutedsounds.size() > 0) {
            Util.updateSoundFile();
        }
        return mutedsounds;
    }

    public static List<String> unmuteWildcard(String wildcard) {
        ArrayList<String> unmutedsounds = new ArrayList<String>();
        try {
            String sounds = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "soundmap.txt", new String[0])));
            for (String sound : sounds.split("\n")) {
                if (sound.length() < 4) continue;
                String soundname = sound.replace(",", "");
                int mutedvalue = -1;
                if (soundname.startsWith("!")) {
                    mutedvalue = 0;
                    soundname = soundname.substring(1);
                } else if (soundname.contains("-")) {
                    try {
                        String[] soundsplit = soundname.split("-");
                        if (soundsplit.length == 2) {
                            mutedvalue = Integer.parseInt(soundsplit[0]);
                            soundname = soundsplit[1];
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (soundname.toLowerCase().contains(wildcard.toLowerCase())) {
                    mutedvalue = -1;
                    unmutedsounds.add(soundname.trim());
                }
                MuteEvent.ismutedsoundmap.put(soundname.trim(), mutedvalue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (unmutedsounds.size() > 0) {
            Util.updateSoundFile();
        }
        return unmutedsounds;
    }
}

