/*
 * Decompiled with CFR 0.152.
 */
package link.infra.borderlessmining.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import link.infra.borderlessmining.config.ConfigHandler;
import link.infra.borderlessmining.util.SettingBorderlessFullscreen;
import link.infra.borderlessmining.util.WindowHooks;
import link.infra.borderlessmining.util.WindowResolutionChangeWrapper;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_313;
import net.minecraft.class_319;
import net.minecraft.class_323;
import net.minecraft.class_3678;
import net.minecraft.class_543;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1041.class})
public abstract class WindowMixin
implements WindowHooks {
    @Shadow
    private int field_5175;
    @Shadow
    private int field_5185;
    @Shadow
    private int field_5174;
    @Shadow
    private int field_5184;
    @Shadow
    private boolean field_5191;
    @Shadow
    @Final
    private long field_5187;
    @Shadow
    @Final
    @Mutable
    private class_3678 field_5176;
    @Shadow
    private boolean field_5186;
    @Shadow
    @Final
    private class_323 field_5195;
    private boolean borderlessFullscreen = false;
    private static final Logger LOGGER = LogManager.getLogger(WindowMixin.class);

    @Shadow
    public abstract int method_4499();

    @Shadow
    public abstract int method_4477();

    @Shadow
    public abstract int method_4480();

    @Shadow
    public abstract int method_4507();

    private boolean borderlessmining_setBorderlessFullscreen(boolean newValue) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (this.borderlessFullscreen != newValue) {
            this.borderlessFullscreen = newValue;
            try {
                class_310.method_1551().field_1690.field_1857 = newValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (newValue) {
                int height;
                int width;
                int y;
                int x;
                this.field_5175 = this.method_4499();
                this.field_5185 = this.method_4477();
                this.field_5174 = this.method_4480();
                this.field_5184 = this.method_4507();
                if (ConfigHandler.getInstance().customWindowDimensions != null && ConfigHandler.getInstance().customWindowDimensions.enabled && !ConfigHandler.getInstance().customWindowDimensions.useMonitorCoordinates) {
                    x = 0;
                    y = 0;
                    width = 0;
                    height = 0;
                } else if (ConfigHandler.getInstance().forceWindowMonitor < 0) {
                    class_313 monitor = this.field_5195.method_1681((class_1041)this);
                    if (monitor == null) {
                        LOGGER.error("Failed to get a valid monitor for determining fullscreen size!");
                        this.borderlessFullscreen = false;
                        return false;
                    }
                    class_319 mode = monitor.method_1617();
                    x = monitor.method_1616();
                    y = monitor.method_1618();
                    width = mode.method_1668();
                    height = mode.method_1669();
                } else {
                    long monitorHandle;
                    PointerBuffer monitors = GLFW.glfwGetMonitors();
                    if (monitors == null || monitors.limit() < 1) {
                        LOGGER.error("Failed to get a valid monitor list for determining fullscreen position!");
                        this.borderlessFullscreen = false;
                        return false;
                    }
                    if (ConfigHandler.getInstance().forceWindowMonitor >= monitors.limit()) {
                        LOGGER.warn("Monitor " + ConfigHandler.getInstance().forceWindowMonitor + " is greater than list size " + monitors.limit() + ", using monitor 0");
                        monitorHandle = monitors.get(0);
                    } else {
                        monitorHandle = monitors.get(ConfigHandler.getInstance().forceWindowMonitor);
                    }
                    try (MemoryStack stack = MemoryStack.stackPush();){
                        IntBuffer xBuf = stack.mallocInt(1);
                        IntBuffer yBuf = stack.mallocInt(1);
                        GLFW.glfwGetMonitorPos((long)monitorHandle, (IntBuffer)xBuf, (IntBuffer)yBuf);
                        x = xBuf.get();
                        y = yBuf.get();
                    }
                    GLFWVidMode mode = GLFW.glfwGetVideoMode((long)monitorHandle);
                    if (mode == null) {
                        LOGGER.error("Failed to get a video mode for the current monitor!");
                        this.borderlessFullscreen = false;
                        return false;
                    }
                    width = mode.width();
                    height = mode.height();
                }
                if (ConfigHandler.getInstance().customWindowDimensions != null) {
                    ConfigHandler.CustomWindowDimensions dims = ConfigHandler.getInstance().customWindowDimensions;
                    if (dims.enabled) {
                        if (dims.useMonitorCoordinates) {
                            x += dims.x;
                            y += dims.y;
                        } else {
                            x = dims.x;
                            y = dims.y;
                        }
                        if (dims.width > 0 && dims.height > 0) {
                            width = dims.width;
                            height = dims.height;
                        } else if (!dims.useMonitorCoordinates) {
                            LOGGER.error("Both width and height must be > 0 when specifying absolute coordinates!");
                            this.borderlessFullscreen = false;
                            return false;
                        }
                    }
                }
                GLFW.glfwSetWindowAttrib((long)this.field_5187, (int)131077, (int)0);
                GLFW.glfwSetWindowPos((long)this.field_5187, (int)x, (int)y);
                GLFW.glfwSetWindowSize((long)this.field_5187, (int)width, (int)height);
            } else {
                GLFW.glfwSetWindowAttrib((long)this.field_5187, (int)131077, (int)1);
                GLFW.glfwSetWindowPos((long)this.field_5187, (int)this.field_5175, (int)this.field_5185);
                GLFW.glfwSetWindowSize((long)this.field_5187, (int)this.field_5174, (int)this.field_5184);
            }
        }
        return true;
    }

    private void onWindowFocusChanged(long window, boolean focused, CallbackInfo ci) {
        if (window == this.field_5187) {
            if (ConfigHandler.getInstance().isEnabled() && this.borderlessFullscreen && focused) {
                GLFW.glfwSetWindowAttrib((long)this.field_5187, (int)131079, (int)1);
            } else {
                GLFW.glfwSetWindowAttrib((long)this.field_5187, (int)131079, (int)0);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void onConstruction(class_3678 prevEventHandler, class_323 monitorTracker, class_543 settings, String videoMode, String title, CallbackInfo info) {
        if (ConfigHandler.getInstance().isEnabled()) {
            WindowResolutionChangeWrapper eventHandlerWrapper = new WindowResolutionChangeWrapper(prevEventHandler);
            this.field_5176 = eventHandlerWrapper;
            if (((SettingBorderlessFullscreen)settings).isBorderlessFullscreen()) {
                eventHandlerWrapper.setEnabled(false);
                this.borderlessmining_setBorderlessFullscreen(true);
                eventHandlerWrapper.setEnabled(true);
            }
        }
    }

    @Shadow
    public abstract void method_15998();

    @Inject(method={"toggleFullscreen"}, at={@At(value="HEAD")}, cancellable=true)
    public void onToggleFullscreen(CallbackInfo info) {
        if (ConfigHandler.getInstance().isEnabledDirty()) {
            ConfigHandler.getInstance().save(!this.borderlessmining_getFullscreenState());
            info.cancel();
            return;
        }
        if (ConfigHandler.getInstance().isEnabled()) {
            this.field_5191 = false;
            info.cancel();
            this.borderlessmining_setBorderlessFullscreen(!this.borderlessFullscreen);
        }
    }

    @Inject(method={"isFullscreen"}, at={@At(value="RETURN")}, cancellable=true)
    public void onIsFullscreen(CallbackInfoReturnable<Boolean> cir) {
        if (ConfigHandler.getInstance().isEnabled()) {
            cir.setReturnValue((Object)this.borderlessFullscreen);
        }
    }

    @Inject(method={"applyVideoMode"}, at={@At(value="HEAD")})
    private void onApplyVideoMode(CallbackInfo info) {
        if (ConfigHandler.getInstance().isEnabledDirty()) {
            ConfigHandler.getInstance().save();
            this.field_5186 = false;
        }
    }

    @Override
    public boolean borderlessmining_getFullscreenState() {
        return ConfigHandler.getInstance().isEnabled() ? this.borderlessFullscreen : this.field_5191;
    }

    @Override
    public void borderlessmining_updateEnabledState(boolean destEnabledState, boolean currentFullscreenState, boolean destFullscreenState) {
        if (destEnabledState) {
            if (currentFullscreenState) {
                this.field_5191 = false;
                if (destFullscreenState) {
                    this.method_15998();
                }
            }
            if (destFullscreenState) {
                this.borderlessmining_setBorderlessFullscreen(true);
            }
        } else {
            if (currentFullscreenState) {
                this.borderlessmining_setBorderlessFullscreen(false);
            }
            if (destFullscreenState) {
                this.field_5191 = true;
            }
        }
    }
}

