/*
 * Decompiled with CFR 0.152.
 */
package link.infra.borderlessmining.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.ArrayList;
import link.infra.borderlessmining.config.ConfigHandler;
import link.infra.borderlessmining.config.ConfigScreen;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_316;
import net.minecraft.class_4064;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;

public class ModMenuCompat
implements ModMenuApi {
    private static final Logger LOGGER = LogManager.getLogger(ModMenuCompat.class);

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            final ConfigHandler configHandler = ConfigHandler.getInstance();
            return new ConfigScreen((class_2561)new class_2588("config.borderlessmining.title"), parent){

                @Override
                public void save() {
                    configHandler.save();
                }

                @Override
                public void addElements() {
                    PointerBuffer monitors;
                    this.addOption((class_316)class_4064.method_32524((String)"config.borderlessmining.general.enabled", (class_2561)new class_2588("config.borderlessmining.general.enabled.tooltip"), options -> configHandler.isEnabledOrPending(), (options, option, value) -> configHandler.setEnabledPending((boolean)value)));
                    this.addOption((class_316)class_4064.method_32524((String)"config.borderlessmining.general.videomodeoption", (class_2561)new class_2588("config.borderlessmining.general.videomodeoption.tooltip"), options -> configHandler2.addToVanillaVideoSettings, (options, option, value) -> {
                        configHandler2.addToVanillaVideoSettings = value;
                    }));
                    this.addOption((class_316)class_4064.method_32524((String)"config.borderlessmining.general.enabledmac", (class_2561)new class_2588("config.borderlessmining.general.enabledmac.tooltip"), options -> configHandler2.enableMacOS, (options, option, value) -> {
                        configHandler2.enableMacOS = value;
                    }));
                    ArrayList<Object> monitorNames = new ArrayList<Object>();
                    monitorNames.add(class_1074.method_4662((String)"config.borderlessmining.general.forcemonitor.current", (Object[])new Object[0]));
                    int currentMonitor = configHandler.forceWindowMonitor + 1;
                    if (currentMonitor < 0) {
                        currentMonitor = 0;
                    }
                    if ((monitors = GLFW.glfwGetMonitors()) == null || monitors.limit() < 1) {
                        LOGGER.warn("Failed to get a valid monitor list!");
                        currentMonitor = 0;
                    } else {
                        if (configHandler.forceWindowMonitor >= monitors.limit()) {
                            LOGGER.warn("Monitor " + configHandler.forceWindowMonitor + " is greater than list size " + monitors.limit() + ", using monitor 0");
                            currentMonitor = 0;
                        }
                        while (monitors.hasRemaining()) {
                            long monitorHandle = monitors.get();
                            monitorNames.add(GLFW.glfwGetMonitorName((long)monitorHandle) + " (" + (monitorNames.size() - 1) + ")");
                        }
                    }
                    int finalCurrentMonitor = currentMonitor;
                    this.addOption((class_316)class_4064.method_35694((String)"config.borderlessmining.general.forcemonitor", monitorNames, class_2585::new, options -> (String)monitorNames.get(finalCurrentMonitor), (options, option, value) -> {
                        int index = monitorNames.indexOf(value);
                        if (index > -1) {
                            configHandler2.forceWindowMonitor = index - 1;
                        }
                    }));
                    this.addHeading((class_2561)new class_2588("config.borderlessmining.dimensions").method_27692(class_124.field_1067));
                    this.addOption((class_316)class_4064.method_32522((String)"config.borderlessmining.dimensions.enabled", options -> configHandler2.customWindowDimensions.enabled, (options, option, value) -> {
                        configHandler2.customWindowDimensions = configHandler2.customWindowDimensions.setEnabled((boolean)value);
                    }));
                    this.addOption((class_316)class_4064.method_32524((String)"config.borderlessmining.dimensions.monitorcoordinates", (class_2561)new class_2588("config.borderlessmining.dimensions.monitorcoordinates.tooltip"), options -> configHandler2.customWindowDimensions.useMonitorCoordinates, (options, option, value) -> {
                        configHandler2.customWindowDimensions = configHandler2.customWindowDimensions.setUseMonitorCoordinates((boolean)value);
                    }));
                    this.addIntField((class_2561)new class_2588("config.borderlessmining.dimensions.x"), () -> configHandler2.customWindowDimensions.x, value -> {
                        configHandler2.customWindowDimensions = configHandler2.customWindowDimensions.setX((int)value);
                    });
                    this.addIntField((class_2561)new class_2588("config.borderlessmining.dimensions.y"), () -> configHandler2.customWindowDimensions.y, value -> {
                        configHandler2.customWindowDimensions = configHandler2.customWindowDimensions.setY((int)value);
                    });
                    this.addIntField((class_2561)new class_2588("config.borderlessmining.dimensions.width"), () -> configHandler2.customWindowDimensions.width, value -> {
                        configHandler2.customWindowDimensions = configHandler2.customWindowDimensions.setWidth((int)value);
                    });
                    this.addIntField((class_2561)new class_2588("config.borderlessmining.dimensions.height"), () -> configHandler2.customWindowDimensions.height, value -> {
                        configHandler2.customWindowDimensions = configHandler2.customWindowDimensions.setHeight((int)value);
                    });
                }
            };
        };
    }
}

