/*
 * Decompiled with CFR 0.152.
 */
package link.infra.borderlessmining.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import link.infra.borderlessmining.util.WindowHooks;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigHandler {
    private static final transient Path configFile = FabricLoader.getInstance().getConfigDir().resolve("borderlessmining.json");
    private static final transient Logger LOGGER = LogManager.getLogger(ConfigHandler.class);
    private static transient ConfigHandler INSTANCE = null;
    private boolean enableBorderlessFullscreen = true;
    public boolean addToVanillaVideoSettings = true;
    public boolean enableMacOS = false;
    public CustomWindowDimensions customWindowDimensions = CustomWindowDimensions.INITIAL;
    public int forceWindowMonitor = -1;
    private transient boolean enabledPending = true;
    private transient boolean enabledDirty = false;

    private ConfigHandler() {
    }

    public static ConfigHandler getInstance() {
        if (INSTANCE == null) {
            Gson gson = new Gson();
            try (FileReader reader2 = new FileReader(configFile.toFile());){
                INSTANCE = (ConfigHandler)gson.fromJson((Reader)reader2, ConfigHandler.class);
            }
            catch (FileNotFoundException reader2) {
            }
            catch (IOException e) {
                LOGGER.error("Failed to read configuration", (Throwable)e);
            }
            if (INSTANCE == null) {
                INSTANCE = new ConfigHandler();
                INSTANCE.save(false);
            }
            ConfigHandler.INSTANCE.enabledPending = ConfigHandler.INSTANCE.enableBorderlessFullscreen;
        }
        return INSTANCE;
    }

    public void setEnabledPending(boolean en) {
        if (this.enabledPending != en) {
            this.enabledPending = en;
            this.enabledDirty = en != this.isEnabled();
        }
    }

    public boolean isEnabledOrPending() {
        return this.enabledDirty ? this.enabledPending : this.isEnabled();
    }

    public boolean isEnabledDirty() {
        return this.enabledDirty;
    }

    public boolean isEnabled() {
        return this.enableBorderlessFullscreen && (!class_310.field_1703 || this.enableMacOS);
    }

    public void save() {
        WindowHooks window = (WindowHooks)class_310.method_1551().method_22683();
        this.save(window.borderlessmining_getFullscreenState());
    }

    public void save(boolean destFullscreenState) {
        if (this.enabledDirty) {
            WindowHooks window = (WindowHooks)class_310.method_1551().method_22683();
            boolean currentState = window.borderlessmining_getFullscreenState();
            this.enableBorderlessFullscreen = this.enabledPending;
            this.enabledDirty = false;
            window.borderlessmining_updateEnabledState(this.isEnabled(), currentState, destFullscreenState);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(configFile.toFile());){
            gson.toJson((Object)this, ConfigHandler.class, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save configuration", (Throwable)e);
        }
    }

    public static class CustomWindowDimensions {
        public static final transient CustomWindowDimensions INITIAL = new CustomWindowDimensions();
        public final boolean enabled;
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public boolean useMonitorCoordinates;

        private CustomWindowDimensions() {
            this.enabled = false;
            this.x = 0;
            this.y = 0;
            this.width = 0;
            this.height = 0;
            this.useMonitorCoordinates = true;
        }

        public CustomWindowDimensions(boolean enabled, int x, int y, int width, int height, boolean useMonitorCoordinates) {
            this.enabled = enabled;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.useMonitorCoordinates = useMonitorCoordinates;
        }

        public CustomWindowDimensions setEnabled(boolean enabled) {
            return new CustomWindowDimensions(enabled, this.x, this.y, this.width, this.height, this.useMonitorCoordinates);
        }

        public CustomWindowDimensions setX(int x) {
            return new CustomWindowDimensions(this.enabled, x, this.y, this.width, this.height, this.useMonitorCoordinates);
        }

        public CustomWindowDimensions setY(int y) {
            return new CustomWindowDimensions(this.enabled, this.x, y, this.width, this.height, this.useMonitorCoordinates);
        }

        public CustomWindowDimensions setWidth(int width) {
            return new CustomWindowDimensions(this.enabled, this.x, this.y, width, this.height, this.useMonitorCoordinates);
        }

        public CustomWindowDimensions setHeight(int height) {
            return new CustomWindowDimensions(this.enabled, this.x, this.y, this.width, height, this.useMonitorCoordinates);
        }

        public CustomWindowDimensions setUseMonitorCoordinates(boolean useMonitorCoordinates) {
            return new CustomWindowDimensions(this.enabled, this.x, this.y, this.width, this.height, useMonitorCoordinates);
        }
    }
}

