/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import xaero.common.AXaeroMinimap;
import xaero.common.patreon.Patreon;
import xaero.common.patreon.decrypt.DecryptInputStream;
import xaero.common.settings.ModSettings;

public class Internet {
    public static Cipher cipher = null;

    public static void checkModVersion(AXaeroMinimap modMain) {
        String s = modMain.getVersionsURL();
        s = s.replaceAll(" ", "%20");
        try {
            if (cipher == null) {
                throw new Exception("Cipher instance is null!");
            }
            URL url = new URL(s);
            URLConnection conn = url.openConnection();
            conn.setReadTimeout(900);
            conn.setConnectTimeout(900);
            if (conn.getContentLengthLong() > 524288L) {
                throw new IOException("Input too long to trust!");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new DecryptInputStream(conn.getInputStream(), cipher), "UTF8"));
            String line = reader.readLine();
            if (line != null) {
                modMain.setMessage("\u00a7e\u00a7l" + line);
            }
            if ((line = reader.readLine()) != null) {
                modMain.setNewestUpdateID(Integer.parseInt(line));
            }
            boolean versionFound = false;
            String[] current = modMain.getVersionID().split("_");
            while ((line = reader.readLine()) != null) {
                String[] args;
                if (line.startsWith("data_widget") && line.length() > 11) {
                    modMain.getWidgetLoader().loadWidget(line.substring(12));
                    continue;
                }
                if (!ModSettings.updateNotification || modMain.getNewestUpdateID() == ModSettings.ignoreUpdate) {
                    modMain.setOutdated(false);
                    break;
                }
                if (line.equals(modMain.getVersionID())) {
                    modMain.setOutdated(false);
                    break;
                }
                if (Patreon.getPatronPledge() < 5) continue;
                if (versionFound) {
                    if (line.startsWith("meta;")) {
                        String[] metadata = line.substring(5).split(";");
                        modMain.setLatestVersionMD5(metadata[0]);
                    }
                    versionFound = false;
                }
                if (!line.startsWith(current[0] + "_") || (args = line.split("_")).length != current.length) continue;
                boolean sameType = true;
                if (current.length > 2) {
                    for (int i = 2; i < current.length && sameType; ++i) {
                        if (args[i].equals(current[i])) continue;
                        sameType = false;
                    }
                }
                if (!sameType) continue;
                modMain.setLatestVersion(args[1]);
                versionFound = true;
            }
            reader.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            modMain.setOutdated(false);
        }
    }

    static {
        try {
            cipher = Cipher.getInstance("RSA");
            KeyFactory factory = KeyFactory.getInstance("RSA");
            byte[] byteKey = Base64.getDecoder().decode(Patreon.getPublicKeyString().getBytes());
            X509EncodedKeySpec X509publicKey = new X509EncodedKeySpec(byteKey);
            PublicKey publicKey = factory.generatePublic(X509publicKey);
            cipher.init(2, publicKey);
        }
        catch (Exception e) {
            cipher = null;
            e.printStackTrace();
        }
    }
}

