/*
 * Decompiled with CFR 0.152.
 */
package troy.autofish;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2635;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;
import troy.autofish.FabricModAutofish;
import troy.autofish.monitor.FishMonitorMP;
import troy.autofish.monitor.FishMonitorMPMotion;
import troy.autofish.monitor.FishMonitorMPSound;
import troy.autofish.scheduler.ActionType;

public class Autofish {
    private class_310 client;
    private FabricModAutofish modAutofish;
    private FishMonitorMP fishMonitorMP;
    private boolean hookExists = false;
    private long hookRemovedAt = 0L;
    public long timeMillis = 0L;

    public Autofish(FabricModAutofish modAutofish) {
        this.modAutofish = modAutofish;
        this.client = class_310.method_1551();
        this.setDetection();
        modAutofish.getScheduler().scheduleRepeatingAction(10000L, () -> {
            if (!modAutofish.getConfig().isPersistentMode()) {
                return;
            }
            if (!this.isHoldingFishingRod()) {
                return;
            }
            if (this.hookExists) {
                return;
            }
            if (modAutofish.getScheduler().isRecastQueued()) {
                return;
            }
            this.useRod();
        });
    }

    public void tick(class_310 client) {
        if (client.field_1687 != null && client.field_1724 != null && this.modAutofish.getConfig().isAutofishEnabled()) {
            this.timeMillis = class_156.method_658();
            if (this.isHoldingFishingRod()) {
                if (client.field_1724.field_7513 != null) {
                    this.hookExists = true;
                    if (this.shouldUseMPDetection()) {
                        this.fishMonitorMP.hookTick(this, client, client.field_1724.field_7513);
                    }
                } else {
                    this.removeHook();
                }
            } else {
                this.removeHook();
            }
        }
    }

    public void tickFishingLogic(class_1297 owner, int ticksCatchable) {
        if (this.modAutofish.getConfig().isAutofishEnabled() && !this.shouldUseMPDetection() && this.client.field_1724 != null && this.client.field_1724.field_7513 != null && ticksCatchable > 0 && owner.method_5667().compareTo(this.client.field_1724.method_5667()) == 0) {
            this.catchFish();
        }
    }

    public void handlePacket(class_2596<?> packet) {
        if (this.modAutofish.getConfig().isAutofishEnabled() && this.shouldUseMPDetection()) {
            this.fishMonitorMP.handlePacket(this, packet, this.client);
        }
    }

    public void handleChat(class_2635 packet) {
        if (this.modAutofish.getConfig().isAutofishEnabled() && !this.client.method_1542() && this.isHoldingFishingRod() && (this.hookExists || this.timeMillis - this.hookRemovedAt < 2000L)) {
            if (StringUtils.deleteWhitespace((String)this.modAutofish.getConfig().getClearLagRegex()).isEmpty()) {
                return;
            }
            Matcher matcher = Pattern.compile(this.modAutofish.getConfig().getClearLagRegex(), 2).matcher(class_3544.method_15440((String)packet.method_11388().getString()));
            if (matcher.find()) {
                this.queueRecast();
            }
        }
    }

    public void catchFish() {
        if (!this.modAutofish.getScheduler().isRecastQueued()) {
            this.queueRodSwitch();
            this.queueRecast();
            this.useRod();
        }
    }

    public void queueRecast() {
        this.modAutofish.getScheduler().scheduleAction(ActionType.RECAST, this.modAutofish.getConfig().getRecastDelay(), () -> {
            if (this.hookExists) {
                return;
            }
            if (!this.isHoldingFishingRod()) {
                return;
            }
            if (this.modAutofish.getConfig().isNoBreak() && this.getHeldItem().method_7919() >= 63) {
                return;
            }
            this.useRod();
        });
    }

    private void queueRodSwitch() {
        this.modAutofish.getScheduler().scheduleAction(ActionType.ROD_SWITCH, this.modAutofish.getConfig().getRecastDelay() - 500L, () -> {
            if (!this.modAutofish.getConfig().isMultiRod()) {
                return;
            }
            this.switchToFirstRod(this.client.field_1724);
        });
    }

    private void removeHook() {
        if (this.hookExists) {
            this.hookExists = false;
            this.hookRemovedAt = this.timeMillis;
            this.fishMonitorMP.handleHookRemoved();
        }
    }

    public void switchToFirstRod(class_746 player) {
        if (player != null) {
            class_1661 inventory = player.method_31548();
            for (int i = 0; i < inventory.field_7547.size(); ++i) {
                class_1799 slot = (class_1799)inventory.field_7547.get(i);
                if (slot.method_7909() != class_1802.field_8378 || i >= 9) continue;
                if (this.modAutofish.getConfig().isNoBreak()) {
                    if (slot.method_7919() >= 63) continue;
                    inventory.field_7545 = i;
                    return;
                }
                inventory.field_7545 = i;
                return;
            }
        }
    }

    public void useRod() {
        class_1268 hand;
        class_1269 actionResult;
        if (this.client.field_1724 != null && this.client.field_1687 != null && (actionResult = this.client.field_1761.method_2919((class_1657)this.client.field_1724, (class_1937)this.client.field_1687, hand = this.getCorrectHand())).method_23665()) {
            if (actionResult.method_23666()) {
                this.client.field_1724.method_6104(hand);
            }
            this.client.field_1773.field_4012.method_3215(hand);
        }
    }

    public boolean isHoldingFishingRod() {
        return this.isItemFishingRod(this.getHeldItem().method_7909());
    }

    private class_1268 getCorrectHand() {
        if (!this.modAutofish.getConfig().isMultiRod() && this.isItemFishingRod(this.client.field_1724.method_6079().method_7909())) {
            return class_1268.field_5810;
        }
        return class_1268.field_5808;
    }

    private class_1799 getHeldItem() {
        if (!this.modAutofish.getConfig().isMultiRod() && this.isItemFishingRod(this.client.field_1724.method_6079().method_7909())) {
            return this.client.field_1724.method_6079();
        }
        return this.client.field_1724.method_6047();
    }

    private boolean isItemFishingRod(class_1792 item) {
        return item == class_1802.field_8378 || item instanceof class_1787;
    }

    public void setDetection() {
        this.fishMonitorMP = this.modAutofish.getConfig().isUseSoundDetection() ? new FishMonitorMPSound() : new FishMonitorMPMotion();
    }

    private boolean shouldUseMPDetection() {
        if (this.modAutofish.getConfig().isForceMPDetection()) {
            return true;
        }
        return !this.client.method_1542();
    }
}

