/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_fabric.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class CollectiveConfigHandler {
    public static PropertyMirror<Boolean> transferItemsBetweenReplacedEntities = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Integer> loopsAmountUsedToGetAllEntityDrops = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Integer> findABlockcheckAroundEntitiesDelayMs = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public static PropertyMirror<Boolean> enableAntiRepostingCheck = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public static PropertyMirror<Boolean> enablePatronPets = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    private static final ConfigTree CONFIG = ConfigTree.builder().beginValue("transferItemsBetweenReplacedEntities", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("When enabled, transfer the held items and armour from replaced entities by any of the Entity Spawn mods which depend on Collective.").finishValue(arg_0 -> transferItemsBetweenReplacedEntities.mirror(arg_0)).beginValue("loopsAmountUsedToGetAllEntityDrops", (ConfigType)ConfigTypes.INTEGER, (Object)100).withComment("The amount of times Collective loops through possible mob drops to get them all procedurally. Drops are only generated when a dependent mod uses them. Lowering this can increase world load time but decrease accuracy.").finishValue(arg_0 -> loopsAmountUsedToGetAllEntityDrops.mirror(arg_0)).beginValue("findABlockcheckAroundEntitiesDelayMs", (ConfigType)ConfigTypes.INTEGER, (Object)30000).withComment("The delay of the is-there-a-block-around-check around entities in ms. Used in mods which depends on a specific blockstate in the world. Increasing this number can increase TPS if needed.").finishValue(arg_0 -> findABlockcheckAroundEntitiesDelayMs.mirror(arg_0)).beginValue("enableAntiRepostingCheck", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Please check out https://stopmodreposts.org/ for more information on why this feature exists.").finishValue(arg_0 -> enableAntiRepostingCheck.mirror(arg_0)).beginValue("enablePatronPets", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Enables pets for Patrons. Will be added in a future release.").finishValue(arg_0 -> enablePatronPets.mirror(arg_0)).build();

    private static void writeDefaultConfig(Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)CONFIG, (OutputStream)s, (ValueSerializer)serializer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setup() {
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        Path p = Paths.get("config", "collective-fabric.json");
        CollectiveConfigHandler.writeDefaultConfig(p, serializer);
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(p, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)CONFIG, (InputStream)s, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            System.out.println("Error loading config");
        }
    }
}

